<!doctype html>
<html lang="en" <?php if($rtl == 1): ?> dir="rtl" <?php endif; ?>>

<head>
    
    <?php if($bs->is_analytics == 1): ?>
        <?php echo $bs->google_analytics_script; ?>

    <?php endif; ?>
    

    
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="<?php echo $__env->yieldContent('meta-description'); ?>">
    <meta name="keywords" content="<?php echo $__env->yieldContent('meta-keywords'); ?>">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    
    <title><?php echo e($bs->website_title); ?></title>

    
    <link rel="shortcut icon" href="<?php echo e(asset('assets/front/img/' . $bs->favicon)); ?>" type="image/png">

    
    <?php echo $__env->make('front.plugin_css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('front.themes_css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->yieldContent('style'); ?>

    
    <?php echo $__env->make('front.themes_header_footer_css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <link rel="stylesheet"
        href="<?php echo e(asset('assets/front/plugin_css/styles.php?color=' . str_replace('#', '', $bs->base_color))); ?>">
    

    
    <?php echo $__env->make('front.plugin_js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    

</head>

<?php
    $bodyClass = '';
    if ($activeTheme == 'bakery') {
        $bodyClass = 'theme-dark';
    }
?>

<body class="<?php echo e($bodyClass); ?>">

    
    <?php if($bs->preloader_status == 1): ?>
        <div id="preloader">
            <div class="loader revolve">
                <img src="<?php echo e(asset('assets/front/img/' . $bs->preloader)); ?>" alt="">
            </div>
        </div>
    <?php endif; ?>
    

    
    <div class="request-loader" id="">
        <img src="<?php echo e(asset('assets/admin/img/loader.gif')); ?>" alt="">
    </div>
    

    
    <?php echo $__env->make('front.themes_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    

    <?php echo $__env->yieldContent('content'); ?>

    
    <?php echo $__env->make('front.themes_footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    

    
    <?php if ($__env->exists('front.partials.popups')) echo $__env->make('front.partials.popups', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    

    
    <?php if ($__env->exists('front.partials.variation-modal')) echo $__env->make('front.partials.variation-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    

    
    <?php if($activeTheme == 'multipurpose'): ?>
        <div class="go-top-area">
            <div class="go-top-wrap">
                <div class="go-top-btn-wrap">
                    <div class="go-top go-top-btn">
                        <i class="fa fa-angle-double-up"></i>
                        <i class="fa fa-angle-double-up"></i>
                    </div>
                </div>
            </div>
        </div>
    <?php else: ?>
        
        <div class="go-top"><i class="fal fa-angle-up"></i></div>
    <?php endif; ?>

    

    
    <div id="WAButton"></div>

    
    <div class="cookie">
        <?php echo $__env->make('cookie-consent::index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    

    
    <?php echo $__env->make('front.themes_model', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script>
        "use strict";
        var mainurl = "<?php echo e(url('/')); ?>";
        var lat = '<?php echo e($bs->latitude); ?>';
        var lng = '<?php echo e($bs->longitude); ?>';
        var rtl = <?php echo e($rtl); ?>;
        var position = "<?php echo e($be->base_currency_symbol_position); ?>";
        var symbol = "<?php echo e($be->base_currency_symbol); ?>";
        var textPosition = "<?php echo e($be->base_currency_text_position); ?>";
        var currText = "<?php echo e($be->base_currency_text); ?>";
        var vap_pub_key = "<?php echo e(env('VAPID_PUBLIC_KEY')); ?>";
        var select = "<?php echo e(__('Select')); ?>";
    </script>

    

    <?php echo $__env->make('front.themes_js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    
    <?php echo $__env->make('front.themes_header_footer_js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    <?php echo $__env->yieldContent('script'); ?>
    
    
    <script>
        // let langCode = "<?php echo e($currentLang->code); ?>";
        // $(function() {
        //     $.datepicker.setDefaults($.datepicker.regional[langCode]); // or any other locale code
        //     $("input.datepicker").datepicker({
        //         minDate: 0,
        //     });

        //     localizeDatepickerDigits(langCode);
        // });


        let langCode = "<?php echo e($currentLang->code); ?>";

        // Define path to your localization files
        let script = document.createElement('script');
        script.src = `<?php echo e(url('assets/front/multipurpose/datepickerJs/datepicker-')); ?>${langCode}.js`;
        script.onload = function() {
            // Initialize datepicker after language file is loaded
            $.datepicker.setDefaults($.datepicker.regional[langCode]);

            $("input.datepicker").datepicker({
                minDate: 0
            });

            localizeDatepickerDigits(langCode);
        };

        document.head.appendChild(script);

        function translateDigits(input, lang) {
            const digitMaps = {
                bn: ['০', '১', '২', '৩', '৪', '৫', '৬', '৭', '৮', '৯'],
                ar: ['٠', '١', '٢', '٣', '٤', '٥', '٦', '٧', '٨', '٩'],
                hi: ['०', '१', '२', '३', '४', '५', '६', '७', '८', '९']
            };
            if (!digitMaps[lang]) return input;

            return input.toString().replace(/\d/g, digit => digitMaps[lang][+digit]);
        }

        function localizeDatepickerDigits(lang) {
            $(".datepicker").datepicker("option", {
                beforeShow: function() {
                    setTimeout(() => {
                        $(".ui-datepicker td span, .ui-datepicker td a, .ui-datepicker-year, .ui-datepicker-month")
                            .each(function() {
                                const text = $(this).text();
                                $(this).text(translateDigits(text, lang));
                            });
                    }, 10);
                },
                onChangeMonthYear: function() {
                    setTimeout(() => {
                        $(".ui-datepicker td span, .ui-datepicker td a, .ui-datepicker-year, .ui-datepicker-month")
                            .each(function() {
                                const text = $(this).text();
                                $(this).text(translateDigits(text, lang));
                            });
                    }, 10);
                }
            });
        }
    </script>
    
    <script>
        $(document).ready(function() {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
        });
    </script>

    
    <?php if($bs->is_whatsapp == 1): ?>
        <script type="text/javascript">
            var whatsapp_popup = <?php echo e($bs->whatsapp_popup); ?>;
            var whatsappImg = "<?php echo e(asset('assets/front/img/whatsapp.svg')); ?>";
            $(function() {
                $('#WAButton').floatingWhatsApp({
                    phone: "<?php echo e($bs->whatsapp_number); ?>", //WhatsApp Business phone number
                    headerTitle: "<?php echo e($bs->whatsapp_header_title); ?>", //Popup Title
                    popupMessage: `<?php echo nl2br($bs->whatsapp_popup_message); ?>`, //Popup Message
                    showPopup: whatsapp_popup == 1 ? true : false, //Enables popup display
                    buttonImage: '<img src="' + whatsappImg + '" />', //Button Image
                    position: "right" //Position: left | right

                });
            });
        </script>
    <?php endif; ?>


    <?php if(session()->has('success')): ?>
        <script>
            "use strict";
            toastr["success"]("<?php echo e(__(session('success'))); ?>");
        </script>
    <?php endif; ?>

    <?php if(session()->has('warning')): ?>
        <script>
            "use strict";
            toastr["warning"]("<?php echo e(__(session('warning'))); ?>");
        </script>
    <?php endif; ?>

    <?php if(session()->has('error')): ?>
        <script>
            "use strict";
            toastr["error"]("<?php echo e(__(session('error'))); ?>");
        </script>
    <?php endif; ?>

    
    <?php if($bs->is_tawkto == 1): ?>
        <?php echo $bs->tawk_to_script; ?>

    <?php endif; ?>
    

    
    <?php if($bs->is_addthis == 1): ?>
        <?php echo $bs->addthis_script; ?>

    <?php endif; ?>
    


    
    <!-- jQuery UI CSS & JS -->
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
    <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>

    

</body>

</html>
<?php /**PATH /Users/samiulalimpratik/Sites/superv/superv/resources/views/front/layout.blade.php ENDPATH**/ ?>